/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.actions;

import com.aptana.debug.ui.DebugUiPlugin;
import com.aptana.debug.ui.SourceDisplayUtil;
import com.aptana.js.debug.core.model.IJSScriptElement;
import com.aptana.js.debug.ui.internal.actions.Messages;
import com.aptana.ui.util.UIUtils;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class OpenScriptSourceAction
extends SelectionProviderAction {
    private IJSScriptElement scriptElement;

    public OpenScriptSourceAction(ISelectionProvider provider) {
        super(provider, Messages.OpenScriptSourceAction_GoToFile);
        this.setToolTipText(Messages.OpenScriptSourceAction_GoToFileForScript);
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.aptana.debug.ui", (String)"icons/full/elcl16/gotoobj_tsk.gif"));
        this.setEnabled(false);
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object element = selection.getFirstElement();
            if (element instanceof IJSScriptElement) {
                this.scriptElement = (IJSScriptElement)element;
                URI location = this.scriptElement.getLocation();
                if (location != null) {
                    IEditorPart editorPart;
                    this.setEnabled(true);
                    int lineNumber = this.scriptElement.getBaseLine();
                    Object sourceElement = DebugUITools.lookupSource((Object)this.scriptElement, (ISourceLocator)this.getSourceLocator((IDebugElement)this.scriptElement)).getSourceElement();
                    IEditorInput editorInput = SourceDisplayUtil.getEditorInput((Object)sourceElement);
                    if (editorInput != null && (editorPart = SourceDisplayUtil.findEditor((IEditorInput)editorInput)) != null) {
                        SourceDisplayUtil.revealLineInEditor((IEditorPart)editorPart, (int)lineNumber);
                    }
                    return;
                }
            }
        } else {
            this.scriptElement = null;
        }
        this.setEnabled(false);
    }

    public void run() {
        URI location;
        if (this.scriptElement == null) {
            this.selectionChanged(this.getStructuredSelection());
            if (this.scriptElement == null) {
                return;
            }
        }
        if ((location = this.scriptElement.getLocation()) == null) {
            return;
        }
        int lineNumber = this.scriptElement.getBaseLine();
        try {
            Object sourceElement = DebugUITools.lookupSource((Object)this.scriptElement, (ISourceLocator)this.getSourceLocator((IDebugElement)this.scriptElement)).getSourceElement();
            IEditorInput editorInput = SourceDisplayUtil.getEditorInput((Object)sourceElement);
            if (editorInput != null) {
                SourceDisplayUtil.openInEditor((IEditorInput)editorInput, (int)lineNumber);
                return;
            }
            MessageDialog.openInformation((Shell)UIUtils.getActiveShell(), (String)Messages.OpenScriptSourceAction_Information, (String)MessageFormat.format(Messages.OpenScriptSourceAction_SourceNotFoundFor_0, location.getPath()));
        }
        catch (CoreException e) {
            DebugUiPlugin.errorDialog((String)Messages.OpenScriptSourceAction_ExceptionWhileOpeningScriptSource, (Throwable)e);
        }
    }

    private ISourceLocator getSourceLocator(IDebugElement debugElement) {
        ISourceLocator sourceLocator = null;
        ILaunch launch = debugElement.getLaunch();
        if (launch != null) {
            sourceLocator = launch.getSourceLocator();
        }
        return sourceLocator;
    }
}

